 @if ($isi == 'N')
     <input type="hidden" id="caridata" value="N">
 @elseif($isi == 'T')
     <input type="hidden" id="caridata" value="T">
 @elseif($isi == 'P')
     <input type="hidden" id="caridata" value="P">
 @endif

 @if ($isi == 'N' || $isi == 'T')
     <table class="table table-sm trn table-bordered table-striped mt-3">
         <thead>
             <tr>
                 <th width="3%">NO</th>
                 <th>No. Transaksi</th>
                 @if ($isi == 'N')
                     <th>Atas Nama</th>
                 @endif
                 <th>Tgl. Transaksi</th>
                 <th>Jml. Item</th>
                 @if ($isi == 'N')
                     <th>Total</th>
                     <th>Sts. Antar</th>
                 @endif
                 <th width="20%">Pilih</th>
             </tr>
         </thead>
         <tbody id="viewtran">
             @forelse ($transaksi as $k)
                 @if ($k->jns_transaksi == 'OFF')
                     <tr>
                         <td class="text-center">{{ $no++ }}</td>
                         <td>{{ $k->kd_transaksi }}</td>
                         @if ($isi == 'N')
                             <td>{{ $k->member->nm_member }}</td>
                         @endif
                         <td>{{ tgl_time($k->created_at) }}</td>
                         <td class="text-center">{{ item($k->id)->jml }}</td>
                         @if ($isi == 'N')
                             <td class="text-right">{{ number_format($k->total, 0, ',', '.') }}</td>
                             <td class="text-center">
                                 @if ($k->sts_antar == 'N')
                                     -
                                 @else
                                     @if ($k->kurir == null)
                                         <button class="btn btn-sm btn-danger kurir"
                                             data-nm="{{ $k->member->nm_member }}"
                                             data-ok="{{ $k->member->ongkirmember->alamat }}"
                                             data-kd="{{ $k->kd_transaksi }}" data-id="{{ $k->id }}">Pilih Kurir
                                             <i class="fa fa-truck ml-2"></i>
                                         </button>
                                     @else
                                         <span class="badge badge-success">Sudah diantar</span>
                                     @endif
                                 @endif
                             </td>
                         @endif
                         <td class="text-center">
                             <button class="btn btn-dark  btn-sm pilih_open  {{ $isi == 'N' ? '' : 'btn-block' }}"
                                 data-kd="{{ $k->kd_transaksi }}"><i class="fa fa-hand-pointer mr-2"></i>
                                 {{ $isi == 'N' ? 'Refund' : 'Open' }}
                             </button>
                             @if ($isi == 'N')
                                 <button class="btn btn-primary  btn-sm print" data-kd="{{ $k->kd_transaksi }}"><i
                                         class="fa fa-print"></i></button>
                                 <button
                                     class="btn btn-success  btn-sm {{ $k->sts_antar == 'Y' ? 'print_label' : '' }}"
                                     {{ $k->sts_antar == 'Y' ? '' : 'disabled' }} data-kd="{{ $k->kd_transaksi }}"><i
                                         class="fa fa-print"></i> Label</button>
                             @endif
                         </td>
                     </tr>
                 @endif
             @empty
                 <tr>
                     <td colspan="12" class="text-center">Data masih kosong</td>
                 </tr>
             @endforelse

         </tbody>
     </table>
 @elseif($isi == 'P')
     <table class="table table-sm trn table-bordered table-striped mt-3">
         <thead>
             <tr>
                 <th width="3%">NO</th>
                 <th width="13%">Kode Barkode</th>
                 <th>Nama Barang</th>
                 <th width="13%">Harga</th>
             </tr>
         </thead>
         <tbody id="viewtran">
             @forelse ($transaksi as $s)
                 <tr>
                     <td class="text-center">{{ $no++ }}</td>
                     <td>{{ $s->kd_produk }}</td>
                     <td>{{ $s->nm_produk }}</td>
                     <td class="text-right" style="font-size: 20px; font-weight: bold">
                         {{ number_format($s->harga_jual, 0, ',', '.') }}
                     </td>
                 </tr>
             @empty
                 <tr>
                     <td colspan="12" class="text-center">Data masih kosong</td>
                 </tr>
             @endforelse

         </tbody>
     </table>
 @endif
